<?php

namespace app\models\form;

use Yii;
use yii\base\Model;
use yii\db\ActiveRecord;
use app\models\User;


class UserSetting extends Model
{
    public $position;


   
    public function rules()
    {
        return [
            
            [['position'], 'required', 'message' => 'Необходимо выбрать дожность'],
            ['position', 'in', 'range' => [0, 1, 2, 3]],
            ['position', 'validatePosition']
            
        ];
    }
    
     public function validatePosition($attribute, $params)
    {
        if (!$this->hasErrors()) {
          
            if ($this->position >= Yii::$app->user->identity->position) {
                $this->addError($attribute, 'Произошла ошибка при выборе должности');
            }
                
        }
    }

    
    
    public function attributeLabels()
	 {
		 
		 return 
		 ['position' => 'Должность'
		 ];
		 
	 }
 
}
